<?php
    // Headers
    header('Access-Control-Allow-Origin: *');
    header('Content-Type: application/json');

    include_once '../../config/Database.php';
    include_once '../../models/employee.php';

    // Instantiate Db & Connect
    $database = new Database();
    $db = $database->connect();

    // Instantiate Employee Object
    $employee = new Employee($db);

    // Employee Query
    $result = $employee->read();
    // Get row count
    $num = $result->rowCount();

    // Check If employee isn't empty
    if($num > 0) {
        // Employee Array
        $employees_arr = array();
        $employees_arr['data'] = array();

        while($row = $result->fetch(PDO::FETCH_ASSOC)) {
            extract($row);

            $employee_item = array(
                'id' => $id,
                'name' => $name,
                'role' => $role,
                'unit' => $unit,
            );

            // Push to "data"
            array_push($employees_arr['data'], $employee_item);
        }

        // Turn to Json $ Output
        echo json_encode($employees_arr);
    } else {
        // No Employee Record Found
        echo json_encode(array('message' => 'No Employee Found'));
    }